import xbmcgui
import time
import binascii
import json


class TinyCache:
    """tiny plugin mem cache class"""
    def __init__(self, addon_id):
        self._id = addon_id
        self._prefix = '{}-{}'.format(self._id, 'cache')
        self._lookup_property = '{}-{}'.format(self._prefix, 'lookup')
        self._cache_idx = {}
        self._win = xbmcgui.Window(10000)
        self._touch()
        self.cleanup()

    def __del__(self):
        self.cleanup()
        self._win.setProperty(self._lookup_property, json.dumps(self._cache_idx))

    def _touch(self):
        if not self._win.getProperty(self._lookup_property):
            self._win.setProperty(self._lookup_property, json.dumps(self._cache_idx))
        else:
            self._cache_idx = json.loads(self._win.getProperty(self._lookup_property))

    def cleanup(self):
        for k, v in self._cache_idx.items():
            if time.time() - v[0] > v[1]:
                self._win.clearProperty('{}-{}'.format(self._prefix, k))

    def set(self, key, value, ttl=60):
        cs = str(binascii.crc32(key.encode()))
        self._cache_idx[cs] = [time.time(), ttl]
        self._win.setProperty('{}-{}'.format(self._prefix, cs), value)

    def get(self, key):
        idx = str(binascii.crc32(key.encode()))
        if idx in self._cache_idx:
            entry = self._win.getProperty('{}-{}'.format(self._prefix, idx))
            if entry:
                return entry
        return None

